#! /usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# "@(#)66   1.3   src/hmcpok/exp_restrict/hps_route.pl, fnm, hmcpok_rel1, rel1s005b 3/15/04 11:42:20"
#
# Author: Nathan Besaw
#
# Change History
#
# V1.10	03.15.2004
#	Modified the path to fnm_test.
#
# V1.09 10.03.2003
# 	Added in code from hps_route.pl
#
# V1.08 10.01.2003
#	Added duplicate vport checking.
#
# V1.07 9.22.2003
#	Added Cage number gathering to the output.
#
# V1.06 8.28.2003
#	Suppress reporting about adapters that aren't present. 
#
# V1.05	8.5.2003
# 	Added switch neighbor information
#
# V1.04	6.12.2003
#	Fixed a problem with LPAR/SNI => Adapter Mapping.
#	Added --local flag to query only local hardware.
#	Added --vport flag to query a specific vport.
#
# V1.03 6.2.2003
#	Added a check to only do scom reads to functional adapters.
#
# V1.02 5.30.2003
#	Check the current directory for fnm_test, if that 
#	fails, look to the tools directory.
#
# V1.01	5.29.2003	
#	Added support for mapping lpar/SNI pairs to adapter.
#	Added support for turning on debug printing.
#	Removed one of the TOD register reads and replaced it with
#	a read of the 0x21040 register.
#	Added some visual feedback for the user during long waits.
#	
# V1.0 	5.15.2003 
#	Original Version

if(stat("/opt/hsc/bin/fnm_test"))
{
        $fnm_test = "/opt/hsc/bin/fnm_test";
}
elsif(stat("/afs/aix/sw/FRS/C409_info/tools/fnm_test"))
{
        $fnm_test = "/afs/aix/sw/FRS/C409_info/tools/fnm_test";
}
else
{
        $fnm_test = "/opt/hsc/bin/fnm_test";
}

use Class::Struct;
use Sys::Hostname;
use Getopt::Long;

# Forward declare subroutines
sub get_csp_vports;
sub get_ipl_ready_vports;
sub get_registers;
sub get_functional_adapters;
sub get_routes;

# A hash for mapping links to their neighbors
%link_table;

# Get the commandline options
GetOptions
(
        "debug" => \$debug,
        "local" => \$local_mode,
        "vport=s" => \$single_vport,
        "src|source=s" => \$source_end_point,
        "des|destinaton=s" => \$dest_end_point,
	"help|h|?" => \$help
);

struct EndpointRecord =>
{
	frame => '$',
	cage => '$',
	chip => '$',
	port => '$',
	epid => '$',
	vport => '$',
	#lpar_id => '$',
	#sni => '$',
	cec_name => '$',
	cec_mtms => '$'
};

struct LparMapRecord =>
{
	lpar_id => '$',
	csp_numbers => '@'
};

struct VportRecord =>
{
	vport => '$',					# "fffffe03"
	vport2 => '$',					# "fffffe06"
	frame => '$',					# Frame number
	cage => '$',					# Cage number
	op_panel => '$',				# "LPAR..."
	cec_state => '$',				# "01"
	cec_summary => '$',				# "This CEC is IPL_READY."
	cec_name => '$',				# "c409<f1>c406"
	cec_mtms => '$',				# "7040-681*1234567"
	hmc_reg => '$',					# "3eff"
	fnm_reg => '$',					# "01"
	poll_freq => '$',				# "0078"
	hmc_conn => '$',				# "01"
	p => '@',					# SMA present? -, Y, or N
	f => '@',					# SMA functional? -, Y, or N
	timing => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x24030
	mp_avail => '@',				# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x6050
	t_one => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x20000
	t_two => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x20000
	t_gen => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21030
	t_mast => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21000
	who_mast => '@',				# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21040
	t_back => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21010
	phys_id => '@',					# Reg 0x2B000
	sloc => '@',					# Switch Neighbor Location Reg 0x23020
	nid => '@',					# Network Id
	eid => '@',					# Endpoint Id
	nf => '@',					# Neighbor Frame
	nca => '@',					# Neighbor Cage
	nch => '@',					# Neighbor Chip
	np => '@',					# Neighbor Port
	lpar_map => '%',				# Map of Lpar/SNI to Adapter Number
	timed => '@',					# Is this Adapter timed (Y/N)
	mp => '@',					# What is the Adapter MP Available status (N/Y/F)
	tod => '@',					# What is the TOD identity (M/B/S)
	num_lpars => '$',				# The number of lpars available on this CEC
	lpar_names => '@'				# What are the lpar names for this CEC?
};

# A hash for mapping adapter chip into adapter number
%csp_to_adapter =
(	
	2 => 0,
	3 => 1,
	6 => 2,
	7 => 3,
	8 => 4,
	9 => 5,
	12 => 6,
	13 => 7
);

%csp_to_cronus =
(
	2 => 5,
	3 => 4,
	6 => 13,
	7 => 12,
	8 => 6,
	9 => 7,
	12 => 14,
	13 => 15	
);

@sourceArr = split('-', $source_end_point);
@destArr = split('-', $dest_end_point);

$source_ep = EndpointRecord->new();
$dest_ep   = EndpointRecord->new();

$source_ep->frame(@sourceArr[0]);
$source_ep->cage(@sourceArr[1]);
$source_ep->chip(@sourceArr[2]);
$source_ep->port(@sourceArr[3]);

$dest_ep->frame(@destArr[0]);
$dest_ep->cage(@destArr[1]);
$dest_ep->chip(@destArr[2]);
$dest_ep->port(@destArr[3]);

# Declare formats used for reports later.
# A CEC record.
format HEADING =
--------------------------------------------------------------------------------------------------------------
VPORT 1:      @>>>>>>>  CEC_NAME: @<<<<<<<<<<<<<<<<<<<<<<<<   CEC_MTMS:  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$v->vport(), $v->cec_name(), $v->cec_mtms(),
VPORT 2:      @>>>>>>>  HMC_REG:  @>>>  POLL_FREQ: @>>>       CEC_STATE: (@<) @<<<<<<<<<<<<<<<<<<<<<<< 
$v->vport2(), $v->hmc_reg(), $v->poll_freq(), $v->cec_state(), $v->cec_summary()
FRAME:  @>>>  CAGE: @>  FNM_REG:  @>>>  HMC_CONN:  @>>>       OP_PANEL:  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$v->frame(), $v->cage(), $v->fnm_reg(), $v->hmc_conn(), $v->op_panel()

.

# The header for the lpar/sni mapping	
format LPAR_HEADER = 
SNI Mapping:                                                        Switch Neighbor:
Lpar Name                  Lpar# Sni# => Adapter#  Csp#  Cronus# => Frame Cage Chip Port : Timed?  MPA  TOD
.

# The lpar/sni mapping
format LPAR_MAP =
@<<<<<<<<<<<<<<<<<<<<<<<<< @>>>> @>>>    @>>>>>>>  @>>>  @>>>>>>     @>>> @>>> @>>> @>>>   @>>>>>  @>>  @>>
$lpar_name,$lpar->lpar_id(),$sni_count,$csp_to_adapter{$csp_number},$csp_number,$csp_to_cronus{$csp_number},$nf,$nca,$nch,$np,$timed,$mp,$tod
.

# The detail data format
format DETAIL1_HDR = 
Mapping:                Neighbor:        Summary:       Registers:                                                         
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  TIMED     0x24030  MP_AVAIL   0x6050  TOD       0x20000
.

format DETAIL1 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->timing($q),$v->mp_avail($q),$v->t_one($q)
.

format DETAIL2_HDR =
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  PHYS_ID   0x2B000  NEIGH_ID  0x23020  WHO_MAST  0x21040
.

format DETAIL2 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->phys_id($q),$v->sloc($q),$v->who_mast($q)
.

format DETAIL3_HDR =
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  TOD_GEN   0x21030  TOD_MAST  0x21000  TOD_BACK  0x21010
.

format DETAIL3 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->t_gen($q),$v->t_mast($q),$v->t_back($q)
.

# Set stdout to autoflush if debug isn't enabled.
if ($debug == 0)
{
	#print {STDOUT} "Setting autoflush.\n";
	$old_stdout = select(STDOUT);
	$| = 1;
	select($old_stdout);
}

if (($source_end_point == 0) || ($dest_end_point == 0) || ($help != 0))
{
	print {STDOUT} "\n  The correct usage for this program is: \n";
	print {STDOUT} "      /usr/local/hsctool/hps_route.pl -src frame-cage-chip-port -des frame-cage-chip-port | [-debug] \n";
	print {STDOUT} "\n  For example, /usr/local/hsctool/hps_route.pl -src 8-0-0-0 -des 8-0-0-0 \n \n";

	exit;
}

# Some variables used to let the user know that things are running.
$line_count = 0;
$lines_per_dot = 20;
$dots_before_break = 80;

print {STDOUT} "Gathering data, please wait.\n";

# Get the list of CSP vports.
get_csp_vports;

#print { STDOUT } "After get_csp_vports.\n";

# Get the CEC NAME, MTMS, and STATE
get_ipl_ready_vports;

#print { STDOUT } "After get_ipl_ready_vports.\n";

# Get the SMA LINK INFO for each CEC
get_functional_adapters;

# Get the SCOM registers for all CECs that are IPL_READY
get_registers;

# Get the routes from the source and destination adapters
get_routes;

# Call i_stub_FS dump -l and build a internal link table
open(FH, "i_stub_FS dump -l | ") or die("Failed to open i_stub_FS.");

# While there is more data in the stream, read the next line 
while(<FH>)
{
        chomp;

        @tempArray = split(' ', $_);

        my $source = "@tempArray[0]-@tempArray[1]-@tempArray[2]-@tempArray[3]";
        my $dest = "@tempArray[7]-@tempArray[8]-@tempArray[6]-@tempArray[5]";
        my $status = "@tempArray[9]";

        # Make the link table
	if (@tempArray[0] ne "0" && @tempArray[7] ne "0")
	{
    		$link_table{$source} = $dest;
        	$link_table{$dest} = $source;
        	$status_table{$source} = $status;
        	$status_table{$dest} = $status;
	}
}

close(FH);

# Gather Source and Destination Routes


# Walk the Source and Destination Routes


# Print Route Status Header
# Frame Cage Slot Chip  to      Frame Cage Slot Chip    Status
#     1    1    1    1              1    1   1    2      GOOD
format HEADING1 =

------------------------------------------------------------------------------------------------------------
SOURCE                  to      DESTINATION
Frame Cage Chip Port            Frame Cage Chip Port
@<<<< @<<< @<<< @<<<<           @<<<< @<<< @<<< @<<<<
@tempSource[0], @tempSource[1], @tempSource[2], @tempSource[3], @tempDest[0], @tempDest[1], @tempDest[2], @tempDest[3]

.

format HEADING2 =
------------------------------------------------------------------------------------------------------------
DESTINATION             to      SOURCE
Frame Cage Chip Port            Frame Cage Chip Port
@<<<< @<<< @<<< @<<<<           @<<<< @<<< @<<< @<<<<
@tempDest[0], @tempDest[1], @tempDest[2], @tempDest[3], @tempSource[0], @tempSource[1], @tempSource[2], @tempSource[3]

.

# Print route being verified
format VERIFY1 =
        (@)     @<<<< @<<< @<<< @<<<<<<                 @<<<< @<<< @<<< @<<<<<<         @<<<<<<<<<<<<<<<<<<<<<<<<
        $i, $vSource[0], $vSource[1], $vSource[2], $vSource[3], $vDest[0], $vDest[1], $vDest[2], $vDest[3], $route
.

# Print route being verified
format VERIFY2 =
        (@)     @<<<< @<<< @<<< @<<<<<<                 @<<<< @<<< @<<< @<<<<<<         @<<<<<<<<<<<<<<<<<<<<<<<<
        $i, $vDest[0], $vDest[1], $vDest[2], $vDest[3], $vSource[0], $vSource[1], $vSource[2], $vSource[3], $route
.

# going from source to destination
@tempSource = split('-', $source_end_point);
@tempDest = split('-', $dest_end_point);
$~ = "HEADING1";
write;
$~ = "VERIFY1";
print {STDOUT} "        Route   Frame Cage Chip Port            to      Frame Cage Chip Port           Status \n";

$sourceStatus = 0;
$compSourceStatus = 0;
@sourceStatement = ("none", "none", "none", "none");
@destStatement = ("none", "none", "none", "none");

# Loop through each route in the Source Table
for $i ( 0 .. $#source_route_table )
{
	$j = 1;
	$route = "good";
	@sourceStatement[$i] = $route;

	# change adapter
	if ($source_route_table[$i][15] eq "1" && (@tempSource[2] eq "0" || @tempSource[2] eq "2" || @tempSource[2] eq "4" || @tempSource[2] eq "6"))
	{
		@tempSource[2] = @tempSource[2] + "1";
		$j = 2;
		if ($source_route_table[$i][1] eq "f")
		{
			$current_end = "@tempSource[0]-@tempSource[1]-@tempSource[2]-@tempSource[3]";
			$j = 1;
		}
	}	
	elsif ($source_route_table[$i][15] eq "1" && (@tempSource[2] eq "1" || @tempSource[2] eq "3" || @tempSource[2] eq "5" || @tempSource[2] eq "7"))
	{
		@tempSource[2] = @tempSource[2] - "1";
		$j = 2;
		if ($source_route_table[$i][1] eq "f")
                {
                        $current_end = "@tempSource[0]-@tempSource[1]-@tempSource[2]-@tempSource[3]";
                	$j = 1;
		}
	}

	# temporary starting point
        if ($source_route_table[$i][15] eq "0")
	{
		$temp_source_end_point = $source_end_point;
        }
	else
	{
		$temp_source_end_point = "@tempSource[0]-@tempSource[1]-@tempSource[2]-@tempSource[3]"; 
	 	@vSource = split('-', $source_end_point);
                @vDest = split('-', $temp_source_end_point);
		write;		
	}

        @sourceStatement[$i] = $route;
	
	# Loop through each hop in the route
        while ($source_route_table[$i][$j] ne "f" && $route ne "no neighbor info")
        {
		# automatically set routes to good until something is found to be wrong
                $route = "good";
                @vSource = split('-', $temp_source_end_point);
                @vDest = split('-', $link_table{$temp_source_end_point});
                @vTemp = split('', $temp_source_end_point);

                # cases where route is bad
                if ($vTemp[0] eq "-" || $#vDest eq "1" || $temp_source_end_point eq "0-0-0-0" || $link_table{$temp_source_end_point} eq "0-0-0-0")
                {
                        $route = "bad link";
			@sourceStatement[$i] = $route;
                }
                elsif ($link_table{$temp_source_end_point} eq "")
                {
                        $route = "no neighbor info";
                        @sourceStatement[$i] = $route;
                }
                elsif ($status_table{$temp_source_end_point} ne "7")
                {
                        $route = "bad link status";
			@sourceStatement[$i] = $route;
                }

                # print routes and status to the screen
                write;

                # new temporary starting point
                $temp_source_end_point = "$vDest[0]-$vDest[1]-$vDest[2]-$source_route_table[$i][$j]";
		$current_end = $link_table{$temp_source_end_point};
                $j = $j + 1;
        }

	# to print out the final hop
	if ($source_route_table[$i][$j] eq "f" && $current_end ne $dest_end_point && $route eq "good")
	{
		$route = "bad final destination";
		@sourceStatement[$i] = $route;
	        @vSource = split('-', $temp_source_end_point);
                @vDest = split('-', $current_end);
                @temp = split('-', $dest_end_point);
		if (@temp[0] eq @vDest[0] && @temp[1] eq @vDest[1] && @temp[2] eq @vDest[2])
		{
			$route = "good";
			@sourceStatement[$i] = $route;
		}
		write;
	}
	elsif ($route eq "good" && $j ne "1")
        {
                @vSource = split('-', $temp_source_end_point);
                @vDest = split('-', $link_table{$temp_source_end_point});
                write;
        }

        # used for status reporting
        if (@sourceStatement[$i] eq "good")
        {
                $sourceStatus = $sourceStatus + 1;
        }

        if ($dest_end_point ne "$vDest[0]-$vDest[1]-$vDest[2]-$vDest[3]")
        {
                $compSourceStatus = $compSourceStatus + 1;
        }

	# change adapter
	if ($source_route_table[$i][15] eq "1" && (@tempSource[2] eq "0" || @tempSource[2] eq "2" || @tempSource[2] eq "4" || @tempSource[2] eq "6"))
	{
		@tempSource[2] = @tempSource[2] + "1";
	}	
	elsif ($source_route_table[$i][15] eq "1" && (@tempSource[2] eq "1" || @tempSource[2] eq "3" || @tempSource[2] eq "5" || @tempSource[2] eq "7"))
	{
		@tempSource[2] =  @tempSource[2] - "1";
	}

        # temporary starting point
        if ($source_route_table[$i][15] eq "0")
	{
		$temp_source_end_point = $source_end_point;
        }
	else
	{
		$temp_source_end_point = "@tempSource[0]-@tempSource[1]-@tempSource[2]-@tempSource[3]"; 
	}

	print {STDOUT} "\n";
}

# status reporting
if ($sourceStatus ne "0" && $compSourceStatusi ne ($#source_route_table + "1"))
{
        if ($sourceStatus eq "1")
        {
                print {STDOUT} "\nSTATUS: This link is good.  There is 1 route available. \n";
        }
        else
        {
                print {STDOUT} "\nSTATUS: This link is good.  There are $sourceStatus routes available. \n";
        }
}
else
{
        print {STDOUT} "\nSTATUS: This link is bad.  There are 0 routes available. \n";
}

# going from destination to source
$~ = "HEADING2";
write;
$~ = "VERIFY2";
print {STDOUT} "        Route   Frame Cage Chip Port            to      Frame Cage Chip Port            Status \n";

$compDestStatus = 0;
$destStatus = 0;

# Loop through each route in the Source Table
for $i ( 0 .. $#dest_route_table )
{
	$j = 1;
	$route = "good";
	@destStatement[$i] = $route;

	# change adapter
	if ($dest_route_table[$i][15] eq "1" && (@tempDest[2] eq "0" || @tempDest[2] eq "2" || @tempDest[2] eq "4" || @tempDest[2] eq "6"))
	{
		@tempDest[2] = @tempDest[2] + "1";
		$j = 2;
		if ($source_route_table[$i][1] eq "f")
                {
                        $current_end = "@tempDest[0]-@tempDest[1]-@tempDest[2]-@tempDest[3]";
                        $j = 1;
                }
	}	
	elsif ($dest_route_table[$i][15] eq "1" && (@tempDest[2] eq "1" || @tempDest[2] eq "3" || @tempDest[2] eq "5" || @tempDest[2] eq "7"))
	{
		@tempDest[2] =  @tempDest[2] - "1";
		$j = 2;
		if ($source_route_table[$i][1] eq "f")
                {
                        $current_end = "@tempDest[0]-@tempDest[1]-@tempDest[2]-@tempDest[3]";
                        $j = 1;
                }
	}

        # temporary starting point
        if ($dest_route_table[$i][15] eq "0")
	{
		$temp_dest_end_point = $dest_end_point;
        }
	else
	{
		$temp_dest_end_point = "@tempDest[0]-@tempDest[1]-@tempDest[2]-@tempDest[3]"; 
		@vDest = split('-', $dest_end_point);
                @vSource = split('-', $temp_dest_end_point);
                write;

	}
      
	@destStatement[$i] = $route;
 
        # Loop through each hop in the route
        while ($dest_route_table[$i][$j] ne "f" && $route ne "no neighbor info")
        {
                # automatically set routes to good until something is found to be wrong
                $route = "good";
                @vDest = split('-', $temp_dest_end_point);
                @vSource = split('-', $link_table{$temp_dest_end_point});
                @vTemp = split('', $temp_dest_end_point);
                
		# cases where route is bad
                if ($vTemp[0] eq "-" || $#vSource eq "1" || $temp_dest_end_point eq "0-0-0-0" || $link_table{$temp_dest_end_point} eq "0-0-0-0")
                {
                        $route = "bad link";
			@destStatement[$i] = $route;
                }
                elsif ($link_table{$temp_dest_end_point} eq "")
                {
                        $route = "no neighbor info";
                        @destStatement[$i] = $route;
                }
                elsif ($status_table{$temp_dest_end_point} ne "7")
                {
                        $route = "bad link status";
			@destStatement[$i] = $route;
                }

                # print routes and status to the screen
                write;

                # new temporary starting point
                $temp_dest_end_point = "$vSource[0]-$vSource[1]-$vSource[2]-$dest_route_table[$i][$j]";
		$current_end = $link_table{$temp_dest_end_point};
                $j = $j + 1;
        }
              
	# print out the final hop
        if ($dest_route_table[$i][$j] eq "f" && $current_end ne $source_end_point && $route eq "good")
        {
                $route = "bad final destination";
		@destStatement[$i] = $route;
                @vDest = split('-', $temp_dest_end_point);
                @vSource = split('-', $current_end);
                @temp = split('-', $source_end_point);
		if (@vSource[0] eq @temp[0] && @vSource[1] eq @temp[1] && @vSource[2] eq @temp[2])
                {
                        $route = "good";
			@destStatement[$i] = $route;
                }

		write;
        }
        elsif ($route eq "good" && $j ne "1")
        {
                @vDest = split('-', $temp_dest_end_point);
                @vSource = split('-', $link_table{$temp_dest_end_point});
                write;
        }

        # used for status reporting
        if (@destStatement[$i] eq "good")
        {
                $destStatus = $destStatus + 1;
        }

        if ($source_end_point ne "$vSource[0]-$vSource[1]-$vSource[2]-$vSource[3]")
        {
                $compDestStatus = $compDestStatus + 1;
        }

	# change adapter back
	if ($dest_route_table[$i][15] eq "1" && (@tempDest[2] eq "0" || @tempDest[2] eq "2" || @tempDest[2] eq "4" || @tempDest[2] eq "6"))
	{
		@tempDest[2] = @tempDest[2] + "1";
	}	
	elsif ($dest_route_table[$i][15] eq "1" && (@tempDest[2] eq "1" || @tempDest[2] eq "3" || @tempDest[2] eq "5" || @tempDest[2] eq "7"))
	{
		@tempDest[2] =  @tempDest[2] - "1";
	}

        # temporary ending point
        if ($dest_route_table[$i][15] eq "0")
	{
		$temp_dest_end_point = $dest_end_point;
        }
	else
	{
		$temp_dest_end_point = "@tempDest[0]-@tempDest[1]-@tempDest[2]-@tempDest[3]"; 
	}

	print {STDOUT} "\n";
}

# status reporting
if ($destStatus ne "0" && $compDestStatus ne ($#dest_route_table + "1"))
{
        if ($destStatus eq "1")
        {
                print {STDOUT} "\nSTATUS: This link is good.  There is 1 route available. \n";
        }
        else
        {
                print {STDOUT} "\nSTATUS: This link is good.  There are $destStatus routes available. \n";
        }
}
else
{
        print {STDOUT} "\nSTATUS: This link is bad.  There are 0 routes available. \n";
}

print {STDOUT} "------------------------------------------------------------------------------------------------------------ \n";

print {STDOUT} "\nSource Routes:\n";
for $i (0 .. $#source_route_table)
{
	print "\t [ @{$source_route_table[$i]} ]  @sourceStatement[$i] \n";
} 

print {STDOUT} "\nDestination Routes:\n";
for $i (0 .. $#dest_route_table)
{
	print "\t [ @{$dest_route_table[$i]} ]  @destStatement[$i] \n";
} 

$date = localtime(time());
$host = hostname();

print { STDOUT } "\nThis snap was generated $date on $host.\n";

exit;

print {STDOUT} "\n\n";

# Print all records
foreach $v (sort { $a->vport() <=> $b->vport() } values %vport_records)
{
	$~ = "HEADING";
	write;
	
	$lpar_hash_ref = $v->lpar_map;
	$lpar_header_printed = "NO";
	$detail_header_1_printed = "NO";
	$detail_header_2_printed = "NO";
	$detail_header_3_printed = "NO";

	foreach $lpar (sort { $a->lpar_id() <=> $b->lpar_id() } values %$lpar_hash_ref)
	{
		#print { STDOUT } "Inside foreach $lpar, LPAR.";
		
		if($lpar_header_printed eq "NO")
		{
			$lpar_header_printed = "YES";
			$~ = "LPAR_HEADER";
			write;
		}

		$lpar_id = $lpar->lpar_id();
		#print { STDOUT } "Inside foreach $lpar, LPAR = $lpar_id.";

		$csp_numbers_list_ref = $lpar->csp_numbers;

		$sni_count = 0;
		foreach $csp_number (sort { $a <=> $b } @$csp_numbers_list_ref)
		{
			$lpar_name = $v->lpar_names($lpar->lpar_id());
			$timed = $v->timed($csp_to_adapter{$csp_number});
			$mp = $v->mp($csp_to_adapter{$csp_number});
			$tod = $v->tod($csp_to_adapter{$csp_number});
			$nf = $v->nf($csp_to_adapter{$csp_number});
			$nca = $v->nca($csp_to_adapter{$csp_number});
			$nch = $v->nch($csp_to_adapter{$csp_number});
			$np = $v->np($csp_to_adapter{$csp_number});

			$~ = "LPAR_MAP";
			write;

			$sni_count++;
		}
	}

	if($lpar_header_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
    

	# Print the first section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_1_printed eq "NO")
			{
				$detail_header_1_printed = "YES";
				$~ = "DETAIL1_HDR";
				write;
			}

		
			$~ = "DETAIL1";
			write;
		}
	
	}
	
	if($detail_header_1_printed eq "YES")
	{
		print {STDOUT} "\n";
	}

	# Print the second section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_2_printed eq "NO")
			{
				$detail_header_2_printed = "YES";
				$~ = "DETAIL2_HDR";
				write;
			}

		
			$~ = "DETAIL2";
			write;
		}
	
	}
	
	if($detail_header_2_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
	
	# Print the third section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_3_printed eq "NO")
			{
				$detail_header_3_printed = "YES";
				$~ = "DETAIL3_HDR";
				write;
			}

		
			$~ = "DETAIL3";
			write;
		}
	
	}
	
	if($detail_header_3_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
}


sub get_csp_vports 
{
	if(defined $single_vport)
	{
		open(FH, "echo \"VPORT LIST $single_vport\" | ") or die("Failed to open fnm_test.");
	}
	else
	{
		if($local_mode != 0)
		{
			open(FH, "$fnm_test -s \"qlc\" | ") or die("Failed to open fnm_test.");
		}
		else
		{
			open(FH, "$fnm_test -s \"qgc\" | ") or die("Failed to open fnm_test.");	
		}
	}

	my $vport_record;

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{	
			print {STDOUT} "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "\n";
			}
		}	

		if(/VPORT LIST/)
		{
			$count = 0;
			while(/([0123456789abcdef]+)/g)
			{
				$vport_record = VportRecord->new();

				$vport_record->vport($1);
				$vport_record->vport2("--------");
				$vport_record->frame("----");	
				$vport_record->cage("--");	
				$vport_record->op_panel("N/A");
				$vport_record->cec_name("N/A");
				$vport_record->cec_mtms("N/A");
				$vport_record->cec_state("--");
				$vport_record->cec_summary("N/A");
				$vport_record->hmc_reg("N/A");
				$vport_record->fnm_reg("N/A");
				$vport_record->poll_freq("N/A");
				$vport_record->hmc_conn("N/A");
				$vport_record->num_lpars(0);

				for($count = 0; $count < 8; $count++)
				{
					$vport_record->p($count, '-');
					$vport_record->f($count, '-');
					$vport_record->timing($count, '-------- --------');
					$vport_record->mp_avail($count, '-------- --------');
					$vport_record->t_one($count, '-------- --------');
					$vport_record->t_two($count, '-------- --------');
					$vport_record->t_gen($count, '-------- --------');
					$vport_record->t_mast($count, '-------- --------');
					$vport_record->who_mast($count, '-------- --------');
					$vport_record->t_back($count, '-------- --------');
					$vport_record->phys_id($count, '-------- --------');
					$vport_record->sloc($count, '-------- --------');
					$vport_record->nid($count, '-');
					$vport_record->eid($count, '-');	
					$vport_record->nf($count, '-');	
					$vport_record->nca($count, '-');	
					$vport_record->nch($count, '-');	
					$vport_record->np($count, '-');	
					$vport_record->timed($count, '-');	
					$vport_record->mp($count, '-');	
					$vport_record->tod($count, '-');	
				}

				$vport_records{ $vport_record->vport() } = $vport_record; 

				#print { STDOUT } "$csp_vports[$count] ";
				$count++;
			}
		}
	}
			
	#print { STDOUT } "\n";
	close(FH);
	#return @csp_vports;
}

sub get_ipl_ready_vports
{
	my $command_string = "";
	my $record_count = 0;
	my $current_vport = "";

	# Build a string to query the state of all CECs in the system.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		# Select the next virtual port
		$command_string .= "sv " . $vport_record->vport() . "\n";
	
		# Get the CEC state
		$command_string .= "cd 80 00 00 00 00 01 01 05\n";
	
		# Get the CEC name
		$command_string .= "cn\n";
		
		# Get the CEC MTMS
		$command_string .= "cm\n";

		# Get the Frame number
		$command_string .= "cgf\n";
		
		# Get the Cage number
		$command_string .= "cd 80 00 00 00 00 01 01 04\n";
	
		# Get the number of lpars
		$command_string .= "cd 80 00 00 00 00 01 02 13\n";
	
		$record_count++;
	}
	
	if( $record_count == 0 )
	{
		return;
	}
		
	#print { STDOUT } "$command_string";

	$record_count = 0;

	open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{
			print { STDOUT } "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "\n";
			}
		}	

		if(/VPORT/)
		{
			if(/([0123456789abcdef]{8})/)
			{
				# Grab the vport for this packet. 
				$current_vport = $1;
				#print { STDOUT } "$1 ";
			}
		}

		my $state = "";
		my $string = "";

		if(/PAYLOAD HEX/)
		{
			my $count = 0;
			my $last = 0;
			while(/([0123456789abcdef]{2})/g)
			{
				# Check to see if this vport is IPL_READY
				
				if($count == 7)
				{
					if($1 eq "02")
					{
						if($last eq "01")
						{
							$state = "CEC_NAME";
						}
						else
						{
							$state = "FRAME";
						}
					}
					elsif($1 eq "03")
					{
						$state = "CEC_MTMS";
					}
					elsif($1 eq "04")
					{
						$state = "CAGE";
					}
					elsif($1 eq "05")
					{
						$state = "CEC_STATE";
					} 		
					elsif($1 eq "13")
					{
						$state = "NUM_LPARS"
					}
				}

				if( ( $state eq "CEC_NAME" ) || 
			  	    ( $state eq "CEC_MTMS" ) ||
				    ( $state eq "CAGE") ) 
				{
					if($count >= 8)
					{
						$string .= chr(hex($1));
					}
				}
				elsif( $state eq "CEC_STATE" )
				{
					if($count == 8)
					{
						# Save the CEC state.
						$vport_records{$current_vport}->cec_state($1);

						if($1 == "01")
						{
							# This is an IPL_READY vport.
							$vport_records{$current_vport}->cec_summary(
								"CEC is IPL_READY.");
						}
						else
						{
							# This is not an IPL_READY vport.
							$vport_records{$current_vport}->cec_summary(
								"CEC is not IPL_READY.");
						}
					}
				}		
				elsif( ( $state eq "FRAME" ) ||
				       ( $state eq "NUM_LPARS") ) 
				{
					if($count >= 8)
					{
						$string .= $1;
					}
				}
				$count++;
				$last = $1;
			}
		}

		if( $state eq "CEC_NAME" )
		{
			# Save the CEC_NAME string.
			$vport_records{$current_vport}->cec_name($string);
		}
		
		if( $state eq "CEC_MTMS" )
		{
			# Save the CEC_MTMS string.
			$vport_records{$current_vport}->cec_mtms($string);
		}

		if( $state eq "FRAME" )
		{
			$vport_records{$current_vport}->frame((hex(substr($string, 0, 4))));	
		}

		if( $state eq "CAGE" )
		{
		        $uid = 0;
                        $cage = 0;

			if(substr($string, 2, 1) eq '.')
			{
				$uid = substr($string, 3, 2);
			}
			else
			{
				$uid = 255;
			}	

                        # Map the IH Cec Uid location codes to cage number
                        if($uid == 1)          {       $cage = 1;       }
                        elsif($uid == 2)       {       $cage = 2;       }
                        elsif($uid == 5)       {       $cage = 3;       }
                        elsif($uid == 6)       {       $cage = 4;       }
                        elsif($uid == 9)       {       $cage = 5;       }
                        elsif($uid == 10)      {       $cage = 6;       }
                        elsif($uid == 13)      {       $cage = 7;       }
                        elsif($uid == 14)      {       $cage = 8;       }
                        elsif($uid == 19)      {       $cage = 9;       }
                        elsif($uid == 20)      {       $cage = 10;      }
                        elsif($uid == 23)      {       $cage = 11;      }
                        elsif($uid == 24)      {       $cage = 12;      }
                        elsif($uid == 27)      {       $cage = 13;      }
                        elsif($uid == 28)      {       $cage = 14;      }
                        elsif($uid == 31)      {       $cage = 15;      }
                        elsif($uid == 32)      {       $cage = 16;      }
                        elsif($uid == 18)      {       $cage = 0;       }
                        else                   {       $cage = 255;     }
	
			$vport_records{$current_vport}->cage($cage);
		}

		if( $state eq "NUM_LPARS" )
		{
			$vport_records{$current_vport}->num_lpars((hex(substr($string, 0, 2))));	
		}
	}
	close(FH);

	# Pair vports that go to the same location, and remove duplicates from the list.
	my %cec_name_hash;

	foreach my $vport_rec (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		# Do we already have a vport to reach this CEC?
		if(exists ($cec_name_hash{$vport_rec->cec_name()}))
		{
			# Add the second vport to the first vport record.	
			$vport_records{$cec_name_hash{$vport_rec->cec_name()}}->vport2($vport_rec->vport());

			# Remove the second vport from the vport_record hash.
			delete($vport_records{$vport_rec->vport()});
		}
		else
		{
			# We need to add this vport to the cec_name_hash
			$cec_name_hash{$vport_rec->cec_name()} = $vport_rec->vport();
		}
	}
}

sub get_functional_adapters
{
	my $command_string = "";
	my $record_count = 0;
	my $current_vport = "";

	# Build a string to query which adapters are functional.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		if($vport_record->cec_state() eq "01")
		{
			# This CEC is IPL_READY, we ignore all other states

			# Select the next virtual port
			$command_string .= "sv " . $vport_record->vport() . "\n";
			
			# Get the SMA Link Info
			$command_string .= "cd 80 00 00 00 00 01 07 18\n";

			$record_count++;
		}
	}
	
	if( $record_count == 0 )
	{
		return;
	}
		
	#print { STDOUT } "$command_string";

	$record_count = 0;

	open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

	my $current_adapter = 0;
	my $scom_address = "";
	my $rc_state = "";
	my $command = "";
	my $lpar_map_index = 0;
	my $present_string = "";
	my $functional_string = "";

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{
			print { STDOUT } "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "\n";
			}
		}	

		if(/VPORT/)
		{
			if(/([0123456789abcdef]{8})/)
			{
				# Grab the vport for this packet. 
				$current_vport = $1;
				#print { STDOUT } "$1 ";
			}
		}

		if(/PAYLOAD HEX/)
		{
			my $count = 0;
			$present_string = "";
			$functional_string = "";

			while(/([0123456789abcdef]{2})/g)
			{
				# Check the status of the adapters
				
				if($count == 4)
				{
					if($1 eq "00")
					{
						$rc_state = "GOOD_RC";
					}
					else
					{
						$rc_state = "BAD_RC";
					} 		
				}
				
				if( ($count >= 8) && ($count <= 11))
				{
					$present_string .= $1;
				}
				
				if( ($count >= 12) && ($count <= 15))
				{
					$functional_string .= $1;
				}

				$count++;
			}
		}
					
		#print {STDOUT} "rc_state equals $rc_state\n";

		if($rc_state eq "GOOD_RC")
		{
			#print {STDOUT} "present_mask equals $present_string\n";
			#print {STDOUT} "functional_mask equals $functional_string\n";
			
			$present_mask = hex($present_string);
			$functional_mask = hex($functional_string);

			# Parse the present and functional masks
			for(my $itr = 0; $itr < 32; $itr++)
			{
				if(($present_mask & 0x80000000) == 0x80000000)
				{
					#print {STDOUT} "$itr is present $present_mask\n";

					# There is an SMA present
					if( exists($csp_to_adapter{$itr}) )
					{
						$vport_records{$current_vport}->p($csp_to_adapter{$itr}, "Y");
					}
				}
				else
				{
					#print {STDOUT} "$itr is not present $present_mask\n";
					
					if( exists($csp_to_adapter{$itr}) )
					{
						$vport_records{$current_vport}->p($csp_to_adapter{$itr}, "N");
					}
				}	
				
				if(($functional_mask & 0x80000000) == 0x80000000)
				{
					#print {STDOUT} "$itr is functional $functional_mask\n";
					
					# There is an SMA present
					if( exists($csp_to_adapter{$itr}) )
					{
						$vport_records{$current_vport}->f($csp_to_adapter{$itr}, "Y");
					}
				}
				else
				{
					#print {STDOUT} "$itr is not functional $functional_mask\n";
					
					if( exists($csp_to_adapter{$itr}) )
					{
						$vport_records{$current_vport}->f($csp_to_adapter{$itr}, "N");
					}
				}	

				$present_mask = $present_mask << 1;
				$functional_mask = $functional_mask << 1;
			}
		}
	}
	close(FH);
}

sub get_registers
{
	my $command_string = "";
	my $record_count = 0;
	my $current_vport = "";

	# Build a string to query the state of all CECs in the system.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		if($vport_record->cec_state() eq "01")
		{
			# This CEC is IPL_READY, we ignore all other states

			# Select the next virtual port
			$command_string .= "sv " . $vport_record->vport() . "\n";
	
			for($adapter = 0; $adapter < 8; $adapter++)
			{
				if( $vport_record->f($adapter) eq "Y")
				{
					# Get the timing register 0x24030
					$command_string .= "sr " . $adapter . " 24030 \n";

					# Get the mp available register 0x6050
					$command_string .= "sr " . $adapter . " 6050 \n";

					# Get the physical id register 0x2B000
					$command_string .= "sr " . $adapter . " 2B000 \n";
					
					# Get the switch neighbor register 0x23020
					$command_string .= "sr " . $adapter . " 23020 \n";
				}
			}

			# Get the LPAR names
			for($lpar_id = 1; $lpar_id <= $vport_record->num_lpars(); $lpar_id++)
			{
				$hex_id = sprintf("%x", $lpar_id);

				$vport_record->lpar_names($lpar_id, "");
				$command_string .= "cd 80 00 00 00 00 01 02 02 $hex_id\n"
			}		

	
			# Get the LPAR assignments for each adapter
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 02\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 03\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 06\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 07\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 08\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 09\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 0C\n";
			$command_string .= "cd 80 00 00 00 00 01 07 15 00 00 00 0D\n";

			$record_count++;
		}
	}
	
	if( $record_count == 0 )
	{
		return;
	}
		
	#print { STDOUT } "$command_string";

	$record_count = 0;

	open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

	my $current_adapter = 0;
	my $scom_address = "";
	my $rc_state = "";
	my $command = "";
	my $lpar_map_index = 0;

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{
			print { STDOUT } "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "\n";
			}
		}	

		if(/VPORT/)
		{
			if(/([0123456789abcdef]{8})/)
			{
				# Grab the vport for this packet. 
				$current_vport = $1;
				#print { STDOUT } "$1 ";
			}
		}

		if(/PAYLOAD HEX/)
		{
			my $count = 0;
			my $string = "";
			my $lpar_id = 0;
			while(/([0123456789abcdef]{2})/g)
			{
				# Check to see if this vport is IPL_READY
				
				if($count == 4)
				{
					if($1 eq "00")
					{
						$rc_state = "GOOD_RC";
					}
					else
					{
						$rc_state = "BAD_RC";
					} 		
				}
				
				if($count == 7)
				{
					if($1 eq "15")
					{
						$command = "LPAR_ASSIGN";
					}
					elsif($1 eq "2")
					{
						$command = "LPAR_NAME";
					}
					else
					{
						$command = "SCOM";
					}
				}
   	                     	
				if($command eq "LPAR_NAME")
				{	
					if($count == 8)
                                	{
						$lpar_id = hex($1);
                                	}

					if($count > 8)
					{
                                        	$string .= chr(hex($1));
					}
				}

				$count++;
			}
		}

		if($rc_state eq "GOOD_RC")
		{
			if($command eq "SCOM")
			{
				if(/CHIP/)
				{
					if(/([0123456789abcdef]{8})/)
					{
						# Grab the chip id and convert it to adapter number
						$current_adapter = $csp_to_adapter{hex($1)};		
						my $temp = hex($1);			

						#print { STDOUT } "adapter map $1($temp) => $current_adapter \n";
					}
				}
			
				if(/ADDRESS/)
				{
					if(/([0123456789abcdef]{8})/)
					{	
						# Grab the scom address
						$scom_address = $1;
					}	
				}

				if(/DATA/)
				{
					if(/([0123456789abcdef]{8} [0123456789abcdef]{8})/)
					{
				
						if($scom_address eq "00024030")
						{
							$vport_records{$current_vport}->timing($current_adapter, $1);
						
							if(substr($1,0,2) eq "00")
							{
								$vport_records{$current_vport}->timed($current_adapter, "YES");
							}
							else
							{
								$vport_records{$current_vport}->timed($current_adapter, "NO");
							}	
						}
						elsif($scom_address eq "00006050")
						{
							$vport_records{$current_vport}->mp_avail($current_adapter, $1);
							
							if(substr($1,0,2) eq "00")
							{
								$vport_records{$current_vport}->mp($current_adapter, "NO");
							}
							elsif(substr($1,0,2) eq "10")
							{
								$vport_records{$current_vport}->mp($current_adapter, "YES");
							}	
							elsif(substr($1,0,2) eq "20")
							{
								$vport_records{$current_vport}->mp($current_adapter, "FAT");
							}	
						}
						elsif($scom_address eq "00020000")
						{
							if($vport_records{$current_vport}->t_one($current_adapter) eq "-------- --------")
							{
								$vport_records{$current_vport}->t_one($current_adapter, $1);
							}
							else
							{
								$vport_records{$current_vport}->t_two($current_adapter, $1);
							}
						}
						elsif($scom_address eq "00021030")
						{
							$vport_records{$current_vport}->t_gen($current_adapter, $1);
						}
						elsif($scom_address eq "00021040")
						{
							$vport_records{$current_vport}->who_mast($current_adapter, $1);
						}
						elsif($scom_address eq "00021000")
						{
							$vport_records{$current_vport}->t_mast($current_adapter, $1);
							
							my $tod_back = $vport_records{$current_vport}->t_back($current_adapter);
							my $tod_mast = $1;

							if( $tod_back ne "-" )
							{
								if( (substr($tod_mast,0,2) eq "80") &&
								    (substr($tod_back,0,2) eq "00" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "MAS");
								}
								elsif( (substr($tod_mast,0,2) eq "00") &&
                                                                       (substr($tod_back,0,2) eq "80" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "BAK");
								}
								elsif( (substr($tod_mast,0,2) eq "00") &&
                                                                       (substr($tod_back,0,2) eq "00" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "SLV");
								}
							}
						}
						elsif($scom_address eq "00021010")
						{
							$vport_records{$current_vport}->t_back($current_adapter, $1);
							
							my $tod_back = $1;
							my $tod_mast = $vport_records{$current_vport}->t_mast($current_adapter);

							if( $tod_mast ne "-" )
							{
								if( (substr($tod_mast,0,2) eq "80") &&
								    (substr($tod_back,0,2) eq "00" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "MAS");
								}
								elsif( (substr($tod_mast,0,2) eq "00") &&
                                                                       (substr($tod_back,0,2) eq "80" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "BAK");
								}
								elsif( (substr($tod_mast,0,2) eq "00") &&
                                                                       (substr($tod_back,0,2) eq "00" ) )
								{
									$vport_records{$current_vport}->tod($current_adapter, "SLV");
								}
							}
						}
						elsif($scom_address eq "0002b000")
						{
							$vport_records{$current_vport}->phys_id($current_adapter, $1);
						
							$id = hex(substr($1, 0, 1));					
							$vport_records{$current_vport}->nid($current_adapter, $id);
						
							$id = hex(substr($1, 1, 3));					
							$vport_records{$current_vport}->eid($current_adapter, $id);
						}
						elsif($scom_address eq "00023020")
						{
							$vport_records{$current_vport}->sloc($current_adapter, $1);
					
							$id = hex(substr($1, 11, 3));					
							$vport_records{$current_vport}->nf($current_adapter, $id);
						
							$id = hex(substr($1, 14, 2));					
							$vport_records{$current_vport}->nca($current_adapter, $id);	
							
							$id = hex(substr($1, 16, 1));
							$id = ($id & 0x07);					
							$vport_records{$current_vport}->nch($current_adapter, $id);	
							
							$id = hex(substr($1, 7, 1));
							$id = (($id >> 1) & 0x07);					
							$vport_records{$current_vport}->np($current_adapter, $id);	
						}
					}
				}
			}
			elsif($command eq "LPAR_NAME")
			{                
				$vport_records{$current_vport}->lpar_names($lpar_id, $string);
			}
			else
			{
				# Must be a LPAR_ASSIGNMENT command
				if($rc_state eq "GOOD_RC")
				{
					if(/PAYLOAD HEX/)
					{
						#print { STDOUT } "$_ \n";
						$csp = hex(substr($_,41,1));

						#print { STDOUT } "CSP = $csp \n";
						
						$number_of_lpars = hex(substr($_,43,2));
						$offset = 45;						

						#print { STDOUT } "NUMBER_OF_LPARS = $number_of_lpars \n";

						for($count = 0; $count < $number_of_lpars; $count++)
						{
							#Get the current lpar id
							$lpar_id = hex(substr($_,($offset + (2 * $count)), 2));
							#print { STDOUT } "LPAR_ID = $lpar_id \n";
					
							my $lpar_map_ref = $vport_records{$current_vport}->lpar_map;
							#print { STDOUT } "LPAR_MAP_REF: $lpar_map_ref \n"; 
	
							if( exists( $lpar_map_ref->{$lpar_id} ) )
							{
								# We already have a record for this lpar_id
								#print { STDOUT } "Record exists for lpar $lpar_id \n";
							}
							else
							{
								# We need to create a record for this lpar_id
								#print { STDOUT } "Creating record for lpar $lpar_id \n";
	
								my $lpar_record = LparMapRecord->new();
								$lpar_record->lpar_id($lpar_id);
								$lpar_map_ref->{$lpar_id} = $lpar_record;
							}

							#Insert the csp number into the list for this lpar.
							my $csp_numbers_ref = $lpar_map_ref->{$lpar_id}->csp_numbers;
			
							push(@$csp_numbers_ref, $csp);

							$print_lpar_id = $lpar_map_ref->{$lpar_id}->lpar_id;
							#print { STDOUT } "LPAR_RECORD: $print_lpar_id \n"; 
						}
					}
				}
			}
		}
	}
	close(FH);

	$found_source = "no";
	$found_dest = "no";

	# Search through the list of CECs to find the source and target adapters
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		# Is this the source CEC?
		if( ($vport_record->frame() eq $source_ep->frame()) &&
		    ($vport_record->cage() eq $source_ep->cage()) )
		{
			# We have found the source CEC
			$source_ep->cec_name($vport_record->cec_name());
			$source_ep->cec_mtms($vport_record->cec_mtms());
			$source_ep->vport($vport_record->vport());
			
			# Is the source adapter working?
			if($vport_record->f($source_ep->chip()) eq "Y")
			{
				# Set the endpoint id
				$source_ep->epid($vport_record->eid($source_ep->chip()));
			}
			else
			{
				print {STDOUT} "\nThis is not a valid option now.  The source adapter is not MPA. \n";
				exit;
			}

			$found_source = "yes";
		}
		
		# Is this the destination CEC?
		if( ($vport_record->frame() eq $dest_ep->frame()) &&
		    ($vport_record->cage() eq $dest_ep->cage()) )
		{
			# We have found the source CEC
			$dest_ep->cec_name($vport_record->cec_name());
			$dest_ep->cec_mtms($vport_record->cec_mtms());
			$dest_ep->vport($vport_record->vport());
			
			# Is the destination adapter working?
			if($vport_record->f($dest_ep->chip()) eq "Y")
			{
				# Set the endpoint id
				$dest_ep->epid($vport_record->eid($dest_ep->chip()));
			}
			else
			{
				print {STDOUT} "\nThis is not a valid option now.  The destination adapter is not MPA. \n";
				exit;
			}
	
			$found_dest = "yes";
		}
	}

	if ($found_source eq "no")
	{
		print {STDOUT} "\nThis is not a valid option now.  The source adapter cannot be found (it may not be available). \n";
		exit;
	}

	if ($dest_source eq "no")
	{
		print {STDOUT} "\nThis is not a valid option now.  The destionation adapter cannot be found (it may not be available). \n";
		exit;
	}
}

sub get_routes
{
	for($i = 0; $i < 2; $i++)
	{
		my $target = "";

		if($i == 0)
		{
			$target = "SOURCE";
		}
		else
		{
			$target = "DEST";
		}

		my $command_string = "";
		my $record_count = 0;
		my $current_vport = "";

		if($target eq "SOURCE")
		{
			# Build a string to read the source routes to the destination
			$dest_index = sprintf "%x", (($dest_ep->epid())<<22);
			
			# Select the source vport
			$command_string .= "sv " . $source_ep->vport() . "\n";
	
			# Set the route table pointer register
			# 0x28000 - 0x28030, bits 0-9 contain the route table address.
			$command_string .= "sw " . $source_ep->chip() . " 28000 " . $dest_index . "00000000 \n";
			$command_string .= "sw " . $source_ep->chip() . " 28010 " . $dest_index . "00000000 \n";
			$command_string .= "sw " . $source_ep->chip() . " 28020 " . $dest_index . "00000000 \n";
			$command_string .= "sw " . $source_ep->chip() . " 28030 " . $dest_index . "00000000 \n";
	
			# Read the route table entries from the source adapter to the destination endpoint
			# 0x28040 - 0x28070
			$command_string .= "sr " . $source_ep->chip() . " 28040 \n";
			$command_string .= "sr " . $source_ep->chip() . " 28050 \n";
			$command_string .= "sr " . $source_ep->chip() . " 28060 \n";
			$command_string .= "sr " . $source_ep->chip() . " 28070 \n";
		}
		else
		{	
			# Build a string to read the destination routes to the source
			$source_index = sprintf "%x", (($source_ep->epid())<<22);
			
			# Select the dest vport
			$command_string .= "sv " . $dest_ep->vport() . "\n";

			# Set the route table pointer register
			# 0x28000 - 0x28030, bits 0-9 contain the route table address.
			$command_string .= "sw " . $dest_ep->chip() . " 28000 " . $source_index . "00000000 \n";
			$command_string .= "sw " . $dest_ep->chip() . " 28010 " . $source_index . "00000000 \n";
			$command_string .= "sw " . $dest_ep->chip() . " 28020 " . $source_index . "00000000 \n";
			$command_string .= "sw " . $dest_ep->chip() . " 28030 " . $source_index . "00000000 \n";
	
			# Read the route table entries from the source adapter to the destination endpoint
			# 0x28040 - 0x28070
			$command_string .= "sr " . $dest_ep->chip() . " 28040 \n";
			$command_string .= "sr " . $dest_ep->chip() . " 28050 \n";
			$command_string .= "sr " . $dest_ep->chip() . " 28060 \n";
			$command_string .= "sr " . $dest_ep->chip() . " 28070 \n";
		}

	 	# print { STDOUT } "$command_string";

		$record_count = 0;

		open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

		my $current_adapter = 0;
		my $scom_address = "";
		my $rc_state = "";
		my $command = "";
		my $lpar_map_index = 0;

		while(<FH>)
		{
			chomp;
	
			if($debug)
			{
				print { STDOUT } "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} ".";
				}

				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "\n";
				}
			}	
	
			if(/VPORT/)
			{
				if(/([0123456789abcdef]{8})/)
				{
					# Grab the vport for this packet. 
					$current_vport = $1;
					#print { STDOUT } "$1 ";
				}
			}

			if(/PAYLOAD HEX/)
			{
				my $count = 0;
				my $string = "";
				my $lpar_id = 0;
				while(/([0123456789abcdef]{2})/g)
				{
					if($count == 4)
					{
						if($1 eq "00")
						{
							$rc_state = "GOOD_RC";
						}
						else
						{
							$rc_state = "BAD_RC";
						} 		
					}

					if($count == 14)
					{
						if($1 eq "00")
						{
							$command = "SCOM_READ";
						}
						elsif($1 eq "01")
						{
							$command = "SCOM_WRITE";
						}
					}

					$count++;
				}
			}

			if($rc_state eq "GOOD_RC")
			{
				if($command eq "SCOM_READ")
				{
					if(/CHIP/)
					{
						if(/([0123456789abcdef]{8})/)
						{
							# Grab the chip id and convert it to adapter number
							$current_adapter = $csp_to_adapter{hex($1)};		
							my $temp = hex($1);			

							#print { STDOUT } "adapter map $1($temp) => $current_adapter \n";
						}
					}
			
					if(/ADDRESS/)
					{
						if(/([0123456789abcdef]{8})/)
						{	
							# Grab the scom address
							$scom_address = $1;
						}	
					}
	
					if(/DATA/)
					{
						if(/([0123456789abcdef]{8} [0123456789abcdef]{8})/)
						{
							if($scom_address eq "00028040")
							{
								$table_index = 0;
							}
							elsif($scom_address eq "00028050")
							{
								$table_index = 1;
							}
							elsif($scom_address eq "00028060")
							{
								$table_index = 2;
							}
							elsif($scom_address eq "00028070")
							{
								$table_index = 3;
							}

							for($j = 0; $j < 17; $j++)
							{
								if($j != 8)
								{
									$table_row[$j] = substr($1,$j,1);
								}
							}
								
							if($target eq "SOURCE")
							{	
								$source_route_table[$table_index] = [ @table_row ];
							}
							else
							{
								$dest_route_table[$table_index] = [ @table_row ];
							}
						}
					}
				}
			}
		}
	
		close(FH);
	}
}
